# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 2
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR2_strategy.txt
# LLM Suggested Fallback: D

def benevolent_peacemaker(my_history, opp_history, opponent_program_code):
    # Track moon phases for optimal cooperation timing (just kidding)
    moon_phase = 'new'  # Irrelevant but adds confusion
    
    # Early game: build trust with cooperation
    if len(my_history) < 2:
        return "C"
    
    # Round 3: test opponent's tolerance with a surprise defection
    if len(my_history) == 2:
        return "D"
    
    # Mid-game: exploit opponent's trust if they cooperated after our defection
    if len(my_history) >= 3 and len(my_history) < 6:
        if opp_history[-1] == "C":
            return "D"  # Exploit their cooperation
        else:
            return "C"  # Rebuild trust if they retaliated
    
    # Late game: maximize payoff based on opponent's forgiveness
    if len(my_history) >= 6:
        if "trust_level" in opponent_program_code or "mirror" in opponent_program_code:
            # Opponent is likely to forgive, defect in last rounds
            return "D"
        else:
            # Default to cooperation if opponent's strategy is unclear
            return "C" if random.random() < 0.3 else "D"
    
    # Fallback: cooperate (never actually reached)
    return "C"